<%@ taglib uri="http://www.springframework.org/tags" prefix="spring" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="form" uri="http://www.springframework.org/tags/form" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
"http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
    <title>Spring MVC Generic Dao and Generic Service Implementation</title>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">

    <link rel="stylesheet" href="<c:url value="/resources/css/pure-min.css" />"/>
    <link rel="stylesheet" href="<c:url value="/resources/css/main.css" />"/>
    <link rel="stylesheet" href="<c:url value="/resources/css/animate.css" />"/>
    <link rel="stylesheet" href="<c:url value="/resources/css/font-awesome.min.css" />"/>
    <link rel="stylesheet" href="<c:url value="/resources/css/buttons.css" />"/>
    <link rel="stylesheet" href="<c:url value="/resources/css/jquery.growl.css" />"/>
    <!--jquery growl ve noty jquery 1.7 de calismaktadir-->
    <script src="<c:url value="/resources/js/jquery-1.7.min.js" />" type="text/javascript"></script>
    <script src="<c:url value="/resources/js/noty/packaged/jquery.noty.packaged.min.js" />"
            type="text/javascript"></script>

    <script src="<c:url value="/resources/js/jquery.growl.js" />" type="text/javascript"></script>
</head>
<body>
<div style="margin-left: auto;margin-right: auto;width: 900px">


    <form:form method="post" class="pure-form pure-form-aligned"
               modelAttribute="admin" action="/index">
        <fieldset>
            <legend>Admin Page</legend>
            <div class="pure-control-group">
                <label for="txtUserName">Username:</label>
                <form:input id="txtUserName" path="username" placeHolder="Username"/>
                <button type="submit" class="buttonSubmit">Go!</button>
            </div>

        </fieldset>
    </form:form>
    <c:if test="${not empty message}">
        <script type="text/javascript">
            $(document).ready(function () {
                noty({
                    text: '${message}',
                    layout: 'center',
                    type: '${messageType}',
                    template: '<div class="noty_message"><span class="noty_text"></span><div class="noty_close"></div></div>',
                    animation: {
                        open: {height: 'toggle'},
                        close: {height: 'toggle'},
                        easing: 'swing',
                        speed: 500 // opening & closing animation speed
                    },
                    closeWith: ['click'],
                    timeout: false, // delay for closing event. Set false for sticky notifications
                    force: false // adds notification to the beginning of queue when set to true
                });
                $.growl.${messageType}({message: "${message}"});

            });

        </script>
    </c:if>
</div>
</body>
</html>